<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Content extends Model 
{

    protected $table = 'lim_contents';
    public $timestamps = true;
    protected $fillable = array('lim_content_type_id', 'lim_category_id', 'cache_time', 'lim_branch_id');
    protected $visible = array('lim_content_type_id', 'lim_category_id', 'cache_time', 'lim_branch_id');

    public function type()
    {
        return $this->belongsTo('App\Models\ContentType', 'lim_content_type_id');
    }

    public function language()
    {
        return $this->hasOne('App\Models\ContentLanguage', 'lim_content_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'lim_category_id');
    }

    public function widgets()
    {
        return $this->morphToMany('App\Models\Widget', 'lim_widget_relation');
    }

    public function fields()
    {
        return $this->morphMany('App\Models\Fields', 'table');
    }

    public function languages()
    {
        return $this->hasMany('App\Models\ContentLanguage', 'lim_content_id');
    }

    public function seoFields()
    {
        return $this->morphMany('App\Models\SeoField', 'table');
    }

    public function branch()
    {
        return $this->belongsTo('App\Models\Branch', 'lim_branch_id');
    }

    public function properties()
    {
        return $this->morphMany('App\Models\Property', 'table');
    }

}